## ---------------------------------------------------------------------------------------------------------------- ##
## Script name: Traditional_morphometrics
## Codes for the paper: Lack of assortative mating in a modified landscape leads to a hybrid swarm
## Script author: Maurine Vilcot (maurine.vilcot@ens-lyon.fr)
## ---------------------------------------------------------------------------------------------------------------- ##

#### -------- Load data ---------------------------------------------------------------------------------------------
library(mclust) # mclustBIC
SpecimenData <- read.csv("Data/Phaulacridium_measurements.csv", header = TRUE, sep = ";", row.names=1)



#### -------- Traditional clustering ---------------------------------------------------------------------------------------------
# Mclust on traditional morphological characters to identify species.
## -- on females -- ##
GHfemaleAll <- subset(SpecimenData, Sex=="Female")
ClassificationFemale <- GHfemaleAll[,c("L", "Lname", "LocationName", "Sex", "In.copula", "Pair_code","Latitude", "Longitude", "Date", "Year")]
GHfemale <- GHfemaleAll[,c("FL", "FL.FW", "PA2")]
BICfemale <- mclustBIC(GHfemale)
summary(BICfemale) 
MCfemale <- Mclust(GHfemale, x=BICfemale)
summary(MCfemale, parameters = TRUE)
plot(MCfemale, what = "classification", col=c("red", "blue"))
ClassificationFemale$cluster_trad <- MCfemale$classification
ClassificationFemale$uncertainty_trad <- MCfemale$uncertainty

## -- on males -- ##
GHmaleAll <- subset(SpecimenData, Sex=="Male")
ClassificationMale <- GHmaleAll[,c("L", "Lname", "LocationName", "Sex", "In.copula", "Pair_code","Latitude", "Longitude", "Date", "Year")]
GHmale <- GHmaleAll[,c("FL", "FL.FW", "PA2")]
BICmale <- mclustBIC(GHmale)
summary(BICmale) 
MCmale <- Mclust(GHmale, x=BICmale, G=2)
summary(MCmale, parameters = TRUE)
plot(MCmale, what = "classification", col=c("red", "blue"))
ClassificationMale$cluster_trad <- MCmale$classification
ClassificationMale$uncertainty_trad <- MCmale$uncertainty

## -- species assignation -- ##
ClusteringTraditional <- rbind(ClassificationFemale, ClassificationMale)
ClusteringTraditional$Species_traditional [ClusteringTraditional$cluster_trad == 1] <- "marginale"
ClusteringTraditional$Species_traditional [ClusteringTraditional$cluster_trad == 2] <- "otagoense"

table(ClusteringTraditional$Species_traditional)
write.csv2(ClusteringTraditional, "Output/Clustering_traditional_individuals.csv")



#### -------- Pair counts ---------------------------------------------------------------------------------------------
# Identify species in mating pairs
ClusteringPairs <- subset(ClusteringTraditional, In.copula=="Pair")

PairFemale <- subset(ClusteringPairs, Sex=="Female")
PairFemale <- PairFemale[, c("Pair_code", "L", "Lname", "LocationName", "Latitude", "Longitude", "Date", "Species_traditional", "uncertainty_trad")] #, "Species_traditional_unc"
colnames(PairFemale)[colnames(PairFemale)=="Species_traditional"] <- "Female"
colnames(PairFemale)[colnames(PairFemale)=="uncertainty_trad"] <- "Uncertainty_Female"

PairMale <- subset(ClusteringPairs, Sex=="Male")
PairMale <- PairMale[, c("Pair_code", "Species_traditional", "uncertainty_trad")] #, "Species_traditional_unc"
colnames(PairMale)[colnames(PairMale)=="Species_traditional"] <- "Male"
colnames(PairMale)[colnames(PairMale)=="uncertainty_trad"] <- "Uncertainty_Male"

ClusteringPairs <- merge(PairFemale, PairMale, by="Pair_code", no.dups = FALSE)
ClusteringPairs$Pair_type [ClusteringPairs$Female == "marginale" & ClusteringPairs$Male == "marginale" ] <- "m/m"
ClusteringPairs$Pair_type [ClusteringPairs$Female == "otagoense" & ClusteringPairs$Male == "otagoense" ] <- "o/o"
ClusteringPairs$Pair_type [ClusteringPairs$Female == "marginale" & ClusteringPairs$Male == "otagoense" ] <- "m/o"
ClusteringPairs$Pair_type [ClusteringPairs$Female == "otagoense" & ClusteringPairs$Male == "marginale" ] <- "o/m"

table(ClusteringPairs$Lname, ClusteringPairs$Pair_type)
write.csv2(ClusteringPairs, "Output/Clustering_traditional_pairs.csv")



#### -------- Exact binom test on assortative mating ---------------------------------------------------------------------------------------------
# Test for assortative mating on mating pairs captured in copula at locations where both species are identified.
#TW
binom.test(8, 16, p=0.49704142, alternative = c("two.sided"),conf.level = 0.95)
#TE
binom.test(4, 21, p=0.190577778, alternative = c("two.sided"),conf.level = 0.95)
#AM
binom.test(1, 30, p=0.051246537, alternative = c("two.sided"),conf.level = 0.95)
#AG
binom.test(1, 3, p=0.389273356, alternative = c("two.sided"),conf.level = 0.95)
#AL
binom.test(1, 14, p=0.184089415, alternative = c("two.sided"),conf.level = 0.95)


